<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/ProdottiDalNegozio.php";
    
    if(isset($_GET["id"])) {
        $datiProdottiDalNegozio = new ProdottiDalNegozio($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $datiProdottiDalNegozio->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione visualizzatore prodotti dall'ecommerce</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore prodotti dal negozio creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore prodotti dal negozio modificato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Prodotti dal negozio</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($datiProdottiDalNegozio)? $datiProdottiDalNegozio->getNome() : "Nuovo visualizzatore di prodotti dal negozio"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($datiProdottiDalNegozio) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($datiProdottiDalNegozio) ? $datiProdottiDalNegozio->getId() : "0")); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label >Nome:</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($datiProdottiDalNegozio) ? $datiProdottiDalNegozio->getNome() : "")) ?>" placeholder="Nome visualizzatore articoli">
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label >Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Mostra nome</label>
                                            <input type="checkbox" class="js-switch" name="mostraTitoloComponente"  value="si" <?php echo((isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getMostraTitoloComponente()=="si") ? "checked":"") ?>>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Categoria prodotti</label>
                                            <select class="form-control" id="idCategoria" name="categoria" onchange="mostraInputCateogrie()">
                                                <option value="0">Tutte le categorie</option>
                                                <option value="-1" <?php echo((isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getCategoria()==-1) ? "selected" : "") ?>>Ultimo articolo delle categorie indicate</option>
                                                <?php 
                                                    $queryCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre=0";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryCategoria);
                                                    while($categoriaPrincipale = $risNomi->fetch_assoc()) {

                                                        if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getCategoria() == $categoriaPrincipale["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$categoriaPrincipale["id"]}\" $selezionato >{$categoriaPrincipale["nome"]}</option>";

                                                        // per ogni categoria madre vedo le categorie figlie
                                                        $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre = {$categoriaPrincipale["id"]}";
                                                        
                                                        $risCategoriaFiglia = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                        while($categoriaFiglia = $risCategoriaFiglia->fetch_assoc()) {
                                                            if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getCategoria() == $categoriaFiglia["id"]) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }
                                                            echo"<option value=\"{$categoriaFiglia["id"]}\" $selezionato > - {$categoriaFiglia["nome"]}</option>";

                                                            // per ogni categoria madre vedo le categorie figlie
                                                            $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre = {$categoriaFiglia["id"]}";
                                                            
                                                            $risSottoCategorieFiglie = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                            while($sottoCategoriaFiglia = $risSottoCategorieFiglie->fetch_assoc()) {
                                                                if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getCategoria() == $sottoCategoriaFiglia["id"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }
                                                                echo"<option value=\"{$sottoCategoriaFiglia["id"]}\" $selezionato > -- {$sottoCategoriaFiglia["nome"]}</option>";
                                                            }
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Scegli la categoria dei prodotti da visualizzare</small>
                                        </div>
                                                                        
                                        <div id="divCategorieIndicate" class="<?php echo(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getCategoria()==-1 ? "col-md-3 form-group" : "d-none") ?>">
                                            <label for="select1">Categorie indicate</label>
                                            <input type="text" class="form-control" name="categorieIndicate" value="<?php echo(isset($datiProdottiDalNegozio) ? $datiProdottiDalNegozio->getCategorieIndicate() : ""); ?>">
                                            <small class="form-text text-muted">Inserisci gli id delle categorie separati da una virgola, ad esempio: 1,5,8</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Escludi categoria</label>
                                            <select class="form-control" name="escludiCategoria">
                                                <option value="-1">Nessuna</option>
                                                <?php 
                                                    $queryCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre=0";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryCategoria);
                                                    while($categoriaPrincipale = $risNomi->fetch_assoc()) {

                                                        if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getEscludiCategoria() == $categoriaPrincipale["id"]) {
                                                            $selezionato  = "selected";
                                                        }
                                                        else {
                                                            $selezionato  = "";
                                                        }
                                                        echo"<option value=\"{$categoriaPrincipale["id"]}\" $selezionato >{$categoriaPrincipale["nome"]}</option>";

                                                        // per ogni categoria madre vedo le categorie figlie
                                                        $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre = {$categoriaPrincipale["id"]}";
                                                        
                                                        $risCategoriaFiglia = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                        while($categoriaFiglia = $risCategoriaFiglia->fetch_assoc()) {
                                                            if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getEscludiCategoria() == $categoriaFiglia["id"]) {
                                                                $selezionato  = "selected";
                                                            }
                                                            else {
                                                                $selezionato  = "";
                                                            }
                                                            echo"<option value=\"{$categoriaFiglia["id"]}\" $selezionato > - {$categoriaFiglia["nome"]}</option>";

                                                            // per ogni categoria madre vedo le categorie figlie
                                                            $queryNomiTag = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre = {$categoriaFiglia["id"]}";
                                                            
                                                            $risSottoCategorieFiglie = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                            while($sottoCategoriaFiglia = $risSottoCategorieFiglie->fetch_assoc()) {
                                                                if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getEscludiCategoria() == $sottoCategoriaFiglia["id"]) {
                                                                    $selezionato  = "selected";
                                                                }
                                                                else {
                                                                    $selezionato  = "";
                                                                }
                                                                echo"<option value=\"{$sottoCategoriaFiglia["id"]}\" $selezionato > -- {$sottoCategoriaFiglia["nome"]}</option>";
                                                            }
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Esclude i prodotti della categoria selezionata</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label >Marca</label>
                                            <select class="form-control" name="marca">
                                                <option value="">tutte</option>
                                                <?php 
                                                    $queryMarche = "SELECT DISTINCT(marca) FROM geecEc_prodotti WHERE marca NOT LIKE ''";
                                                    $result = $geecomDb->eseguiQueryLettura($queryMarche);
                                                    while($marca = $result->fetch_array()) {
                                                        if(isset($datiProdottiDalNegozio) && $marca[0]==$datiProdottiDalNegozio->getMarca()) {
                                                            echo"<option value=\"{$marca[0]}\" SELECTED>{$marca[0]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$marca[0]}\">{$marca[0]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">È possibile aggiungere anche un filtro per marca</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label >Escludi marca</label>
                                            <select class="form-control" name="escludiMarca">
                                                <option value="">nessuna</option>
                                                <?php 
                                                    $queryMarche = "SELECT DISTINCT(marca) FROM geecEc_prodotti WHERE marca NOT LIKE ''";
                                                    $result = $geecomDb->eseguiQueryLettura($queryMarche);
                                                    while($marca = $result->fetch_array()) {
                                                        if(isset($datiProdottiDalNegozio) && $marca[0]==$datiProdottiDalNegozio->getEscludiMarca()) {
                                                            echo"<option value=\"{$marca[0]}\" SELECTED>{$marca[0]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$marca[0]}\">{$marca[0]}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">È possibile escludere i prodotti di una determianata marca</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Lingua prodotti</label>
                                            <select class="form-control" name="lingua">
                                                <option value="">tutte</option>
                                                <?php 
                                                    foreach($lingue as $lingua) {
                                                        if(isset($datiProdottiDalNegozio) && $lingua==$datiProdottiDalNegozio->getLingua()) {
                                                            echo"<option value=\"{$lingua}\" SELECTED>{$lingua}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$lingua}\">{$lingua}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Imposta un filtro per lingua sugli articoli</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Tipo visualizzazione</label>
                                            <select class="form-control" name="tipoVisualizzazione">
                                                <?php
                                                    $arrayClassiElemento = array("tradizionale"=>"Tradizionale","slider"=>"Slider");
                                                    foreach($arrayClassiElemento as $classe=>$numeroELementi) {
                                                        if(isset($datiProdottiDalNegozio) && $classe==$datiProdottiDalNegozio->getTipoVisualizzazione()) {
                                                            echo"<option value=\"$classe\" SELECTED>{$numeroELementi}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">{$numeroELementi}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Imposta un filtro per lingua sugli articoli</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label >Criterio di visualizzazione</label>
                                            <select class="form-control" name="tipoProdotti">
                                            <?php
                                                $arrayOpzioni = array("alfabetico-AZ" => "Alfabetico, dall'inizio", "alfabetico-ZA" => "Alfabetico, dalla fine", "piuVenduto" => "I più venduti", "casuali" => "Casuali","offerta" => "In offerta");
                                                foreach($arrayOpzioni as $chiave=>$valore) {
                                                    if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getTipoProdotti()==$chiave) {
                                                        echo"<option value=\"{$chiave}\" selected>{$valore}</option>";							
                                                    }
                                                    else {
                                                        echo"<option value=\"{$chiave}\">{$valore}</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Scegli il criterio di visualizzazione dei prodotti</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div id="divNumeroArticoli" class="<?php echo(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getCategoria()!=-1 ? "col-md-3 form-group" : "d-none") ?>">
                                            <label for="">Numero prodotti</label>
                                            <input type="number" class="form-control" id="numeroProdotti" name="numeroProdotti" aria-describedby="numero prodotti" value="<?php echo((isset($datiProdottiDalNegozio) ? $datiProdottiDalNegozio->getNumeroProdotti() : "1")) ?>" placeholder="Numero prodotti" required>
                                            <small class="form-text text-muted">Scegli il numero di articoli da visualizzare</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for=""><?= ($datiProdottiDalNegozio->getTipoVisualizzazione()=="classico") ? "Prodotti per riga" : "Elementi per slide (risoluzione desktop)" ?></label>
                                            <select class="form-control" name="dimensioneDivSingoloProdotto">
                                                <?php 
                                                    $dimenisioniSingoloArticolo = array("col-lg-8 mx-auto"=>1,"col-md-6"=>2,"col-md-4"=>3,"col-md-6 col-lg-3"=>4);
                                                    foreach($dimenisioniSingoloArticolo as $dimensione=>$numeroArticoli) {
                                                        if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getDimensioneDivSingoloProdotto()==$dimensione) {
                                                            echo"<option value=\"{$dimensione}\" SELECTED>{$numeroArticoli}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$dimensione}\">{$numeroArticoli}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Scegli il numero di articoli da mostrare su una sola riga a risoluzione desktop</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label >Aspetto immagini</label>
                                            <select class="form-control" name="aspetto">
                                            <?php
                                                $arrayOpzioni = array("altezzaControllata" => "Altezza controllata", "immaginiLibere" => "Immagini libere");
                                                foreach($arrayOpzioni as $chiave=>$valore) {
                                                    if(isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getAspetto()==$chiave) {
                                                        echo"<option value=\"{$chiave}\" selected>{$valore}</option>";							
                                                    }
                                                    else {
                                                        echo"<option value=\"{$chiave}\">{$valore}</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Scegli l'aspetto delle immagini di anteprima</small>
                                        </div>
                                        
                                        <div class="col-md-3">
		                                <div class="row">
				                        <div class="col-md-6 form-group">
				                            <label class="d-block">Mostra prezzo</label>
				                            <input type="checkbox" class="js-switch" name="mostraPrezzo" value="si" <?php echo((isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getMostraPrezzo()=="si") ? "checked":"") ?>>
				                        </div>
				                        
				                        <div class="col-md-6 form-group">
				                            <label class="d-block">Escludi prodotti esauriti</label>
				                            <input type="checkbox" class="js-switch" name="escludiProdottiEsauriti" value="si" <?php echo((isset($datiProdottiDalNegozio) && $datiProdottiDalNegozio->getEscludiProdottiEsauriti()=="si") ? "checked":"") ?>>
				                        </div>
		                                </div>
                                        </div>
                                                                                
                                        <div class="col-md-3 form-group">
                                            <label for="">Etichetta pulsante altri prodotti</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="etichettaPulsanteAltriProdotti" aria-describedby="Etichetta pulsante altri prodotti" value="<?php echo((isset($datiProdottiDalNegozio) ? $datiProdottiDalNegozio->getEtichettaPulsanteAltriProdotti() : "")) ?>" placeholder="Etichetta pulsante altri prodotti">
                                            <small class="form-text text-muted">Lascia vuoto se non vuoi mostrare il pulsante</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Link pulsante altri prodotti</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="linkPulsanteAltriProdotti" aria-describedby="Link pulsante altri prodotti" value="<?php echo((isset($datiProdottiDalNegozio) ? $datiProdottiDalNegozio->getLinkPulsanteAltriProdotti() : "")) ?>" placeholder="Link pulsante altri prodotti">
                                            <small class="form-text text-muted">Il link dove viene reindirizzato l'utente</small>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $datiProdottiDalNegozio->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $datiProdottiDalNegozio->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome = $('#nomeElemento').val();
                var link = $('#linkElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $datiProdottiDalNegozio->getId() ?>,
                        nome:nome,
                        link:link
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $datiProdottiDalNegozio->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function mostraInputCateogrie() {
                var categoria = document.getElementById("idCategoria").value;
                if(categoria==-1) {            
                    document.getElementById("divCategorieIndicate").className = "col-md-3 form-group";
                }
                else {
                    document.getElementById("divCategorieIndicate").className = "d-none";
                }
            }
        </script>
    </body>
</html>
